package it.eng.eremita.jpa.entity;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.types.Identifiable;

@Entity
@Table(name="MAIN_RUOLO")
public class Ruolo implements Serializable,Identifiable<String> {
	
	String id;
	String nomeEsteso;
	
	List<Permesso> permessi;
	
	@Id
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	
	@Column(name="NOME_ESTESO")
	@GraphQLQuery(name="nomeEsteso")
	public String getNomeEsteso() {
		return nomeEsteso;
	}
	public void setNomeEsteso(String nomeEsteso) {
		this.nomeEsteso = nomeEsteso;
	}
	
	@ManyToMany
	@JoinTable(name="MAIN_RUOLO_PERMESSO",
		joinColumns=@JoinColumn(name="RUOLO",referencedColumnName="ID"),
		inverseJoinColumns=@JoinColumn(name="PERMESSO",referencedColumnName="ID"))
	public List<Permesso> getPermessi() {
		return permessi;
	}
	public void setPermessi(List<Permesso> permessi) {
		this.permessi = permessi;
	}
	
	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof Ruolo)) return false;
		
		Ruolo ms = (Ruolo)o;
		if (ms.getId()==this.getId()) return true;
		if (ms.getId()==null) return false;
		return (ms.getId().equals(this.getId()));

	}
	

}
